/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.TrueCondition;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.IConditional;
import slimeknights.mantle.client.book.data.IDataItem;
import slimeknights.mantle.client.book.data.JsonCondition;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentError;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.IDataElement;
import slimeknights.mantle.client.book.repository.BookRepository;

public class PageData
implements IDataItem,
IConditional {
    public String name = null;
    public class_2960 type = Mantle.getResource("blank");
    public String data = "";
    public float scale = 1.0f;
    public JsonCondition condition = new JsonCondition(TrueCondition.ID, new JsonObject());
    public Map<class_2960, JsonElement> extraData = Collections.emptyMap();
    public transient SectionData parent;
    public transient BookRepository source;
    public transient PageContent content;

    public PageData() {
        this(false);
    }

    public PageData(boolean custom) {
        if (custom) {
            this.data = "no-load";
        }
    }

    public String translate(String string) {
        return this.parent.translate(string);
    }

    @Override
    public void load() {
        String data;
        class_3298 pageInfo;
        if (this.name == null) {
            this.name = "page" + this.parent.unnamedPageCounter++;
        }
        this.name = this.name.toLowerCase();
        Class<? extends PageContent> ctype = BookLoader.getPageType(this.type);
        if (!(this.data.isEmpty() || this.data.equals("no-load") || (pageInfo = this.source.getResource(this.source.getResourceLocation(this.data))) == null || (data = this.source.resourceToString(pageInfo)).isEmpty())) {
            Class<? extends PageContent> overriddenType;
            PageTypeOverrider overrider = (PageTypeOverrider)BookLoader.getGson().fromJson(data, PageTypeOverrider.class);
            if (overrider.type != null && (overriddenType = BookLoader.getPageType(overrider.type)) != null) {
                ctype = BookLoader.getPageType(overrider.type);
                this.type = overrider.type;
            }
            if (ctype != null) {
                try {
                    this.content = (PageContent)BookLoader.getGson().fromJson(data, ctype);
                }
                catch (Exception e) {
                    this.content = new ContentError("Failed to create a page of type \"" + String.valueOf(this.type) + "\", perhaps the page file \"" + this.data + "\" is missing or invalid?", e);
                    e.printStackTrace();
                }
            } else {
                this.content = new ContentError("Failed to create a page of type \"" + String.valueOf(this.type) + "\" as it is not registered.");
            }
        }
        if (this.content == null) {
            if (ctype != null) {
                try {
                    this.content = ctype.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
                    this.content = new ContentError("Failed to create a page of type \"" + String.valueOf(this.type) + "\".", e);
                    e.printStackTrace();
                }
            } else {
                this.content = new ContentError("Failed to create a page of type \"" + String.valueOf(this.type) + "\" as it is not registered.");
            }
        }
        try {
            this.content.parent = this;
            this.content.load();
        }
        catch (Exception e) {
            this.content = new ContentError("Failed to load page " + this.parent.name + "." + this.name + ".", e);
            e.printStackTrace();
        }
        this.content.source = this.source;
        for (Field f : this.content.getClass().getFields()) {
            this.processField(f);
        }
    }

    private void processField(Field f) {
        f.setAccessible(true);
        if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) {
            return;
        }
        try {
            Object o = f.get(this.content);
            if (o != null) {
                this.processObject(o, 0);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void processObject(@Nullable Object o, int depth) {
        if (depth > 4 || o == null) {
            return;
        }
        Class<?> c = o.getClass();
        boolean isArray = c.isArray();
        if (!isArray) {
            if (IDataElement.class.isAssignableFrom(c)) {
                ((IDataElement)o).load(this.source);
            }
            return;
        }
        for (int i = 0; i < Array.getLength(o); ++i) {
            this.processObject(Array.get(o, i), depth + 1);
        }
    }

    public String getTitle() {
        String title = this.parent.parent.strings.get(this.parent.name + "." + this.name);
        if (title != null) {
            return title;
        }
        title = this.content.getTitle();
        if (title != null && !title.isEmpty()) {
            return title;
        }
        return this.name;
    }

    @Override
    public boolean isConditionMet() {
        return this.condition.test();
    }

    private static class PageTypeOverrider {
        public class_2960 type;

        private PageTypeOverrider() {
        }
    }
}

